implementation module StdMaybe

//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdMaybe defines the Maybe type.
//	********************************************************************************

::	Maybe x
	=	Just x
	|	Nothing

isJust :: !(Maybe .x) -> Bool
isJust Nothing	= False
isJust _		= True

isNothing :: !(Maybe .x) -> Bool
isNothing Nothing	= True
isNothing _			= False

fromJust :: !(Maybe .x) -> .x
fromJust (Just x) = x

u_isJust	:: !(Maybe .x) -> (!Bool, !Maybe .x)
u_isJust nothing=:Nothing
	= (False, nothing)
u_isJust just
	= (True, just)

u_isNothing	:: !(Maybe .x) -> (!Bool, !Maybe .x)
u_isNothing nothing=:Nothing
	= (True, nothing)
u_isNothing just
	= (False, just)
	
